package easik.sketch;

import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;

import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;

import easik.Easik;
import easik.sketch.edge.SketchEdge;
import easik.sketch.vertex.EntityNode;


/**
 * Graph Listener to set points on edges so that multiple edges between
 * two nodes can be displayed properly.
 * 
 * @author Kevin Green 2006
 * @since 2006-08-21 Kevin Green
 * @version 2006-08-23 Kevin Green
 */
public class SetPoints implements GraphModelListener{
	
	/**
	 * Create the new action
	 */
	public SetPoints(){
		
	}
	
	/**
	 * When action is performed, update point
	 * 
	 * @param e The action event
	 */
	public void graphChanged(GraphModelEvent e ) {
		
		//Create array to store edges in based on source and target
		ArrayList entities = new ArrayList(Easik.getInstance().getFrame().getSketch().getEntities().values());
		int numVer = entities.size(); 
		ArrayList[][] edgeArr = new ArrayList[numVer][numVer];
		for(int i=0; i<numVer; i++){
			for(int j=i; j<numVer; j++){
				ArrayList temp = new ArrayList();
				edgeArr[i][j] = temp;
				edgeArr[j][i] = temp;
			}
		}
		
		//Add edges to array
		Object entireSet[] = Easik.getInstance().getFrame().getSketch().getRoots();
		for(int i=0; i<entireSet.length; i++){
			DefaultGraphCell curObject = (DefaultGraphCell) entireSet[i];
			AttributeMap myMap = ((DefaultGraphCell)entireSet[i]).getAttributes();
			if(curObject.getUserObject() instanceof SketchEdge){
				SketchEdge curEdge = (SketchEdge) curObject.getUserObject();
				edgeArr[entities.indexOf(curEdge.getSourceObj())][entities.indexOf(curEdge.getTargetObj())].add(curObject);
			}
		}
		
		//Process edges
		for(int i=0; i<numVer; i++){
			for(int j=i; j<numVer; j++){
				ArrayList curArray = edgeArr[i][j];
				EntityNode main_source = null;
				EntityNode main_target = null;
				int rise = 0;
				if(curArray.size() > 0){
					main_source = (EntityNode)((SketchEdge)((DefaultGraphCell)curArray.get(0)).getUserObject()).getSourceObj();
					main_target = (EntityNode)((SketchEdge)((DefaultGraphCell)curArray.get(0)).getUserObject()).getTargetObj();
					rise = main_source.getY() - main_target.getY();
				}
				int n = 0;
				if(curArray.size()%2 == 1){
					n=1;
					DefaultEdge curCell = (DefaultEdge) curArray.get(0);
					LinkedList<Point> pointList = new LinkedList<Point>();
					DefaultGraphCell source = 
						(DefaultGraphCell) Easik.getInstance().getFrame().getSketch().getAdapter().getVertexCell(((SketchEdge)curCell.getUserObject()).getSourceObj());
					DefaultGraphCell target =
						(DefaultGraphCell) Easik.getInstance().getFrame().getSketch().getAdapter().getVertexCell(((SketchEdge)curCell.getUserObject()).getTargetObj());;
					
					int sourceX = (int)GraphConstants.getBounds(source.getAttributes()).getCenterX();
					int sourceY = (int)GraphConstants.getBounds(source.getAttributes()).getCenterY();
					int destX = (int)GraphConstants.getBounds(target.getAttributes()).getCenterX();
					int destY = (int)GraphConstants.getBounds(target.getAttributes()).getCenterY();
					AttributeMap myMap = curCell.getAttributes();
					pointList.add(new Point(sourceX, sourceY));
					pointList.add(new Point(((sourceX+destX)/2), ((sourceY+destY)/2)));
					pointList.add(new Point(destX,destY));
					GraphConstants.setPoints(myMap, pointList);
					GraphConstants.setLabelPosition(myMap, new Point(500, 0));
					curCell.setAttributes(myMap);
				}
				for(int k=n; k<curArray.size(); k++){
					DefaultEdge curCell = (DefaultEdge) curArray.get(k);
					LinkedList<Point> pointList = new LinkedList<Point>();
					
					DefaultGraphCell source = 
						(DefaultGraphCell) Easik.getInstance().getFrame().getSketch().getAdapter().getVertexCell(((SketchEdge)curCell.getUserObject()).getSourceObj());
					DefaultGraphCell target =
						(DefaultGraphCell) Easik.getInstance().getFrame().getSketch().getAdapter().getVertexCell(((SketchEdge)curCell.getUserObject()).getTargetObj());;
					
					int sourceX = (int)GraphConstants.getBounds(source.getAttributes()).getCenterX();
					int sourceY = (int)GraphConstants.getBounds(source.getAttributes()).getCenterY();
					int destX = (int)GraphConstants.getBounds(target.getAttributes()).getCenterX();
					int destY = (int)GraphConstants.getBounds(target.getAttributes()).getCenterY();
					Point tempPoint;
					int m=1;
					int p=0;
					if(n == 0)
						m=2;
					if(k%2 == 0){
						p = (k+m)/2;
						tempPoint = calculatePoint(sourceX, sourceY, destX, destY, p);
					}
					else{
						p = -((k+m)/2);
						tempPoint = calculatePoint(sourceX, sourceY, destX, destY, p);
					}
					pointList.add(new Point(sourceX, sourceY));
					pointList.add(tempPoint);
					pointList.add(new Point(destX,destY));
					AttributeMap myMap = curCell.getAttributes();
					GraphConstants.setPoints(myMap, pointList);
					int space = (int)tempPoint.distance((sourceX+destX)/2, (sourceY+destY)/2);
					if(p<0){
						space = space * (-1);
					}
					if(((SketchEdge)curCell.getUserObject()).getSourceObj() == main_source){
						space = space * (-1);
					}
					if(rise>0){
						space = space * (-1);
					}
					GraphConstants.setLabelPosition(myMap, new Point(500, space));
					curCell.setAttributes(myMap);
				}
			}
		}
		
		//Rediplay graph
		Easik.getInstance().getFrame().getSketch().getGraphLayoutCache().reload();
		Easik.getInstance().getFrame().getSketch().repaint();
	}
	
	/**
	 * Calculates the point which the edge should bend to. 
	 * 
	 * @param sourceX The source X co-ord
	 * @param sourceY The source Y co-ord
	 * @param destX The dest X co-ord
	 * @param destY The dest Y co-ord
	 * @param spacer The space from the home position (based on # of edges)
	 * @return The calculated point
	 */
	public Point calculatePoint(int sourceX, int sourceY, int destX, int destY, int spacer){
		//Space constant
		double dist = 30.0; 
		double theta = Math.atan(-((sourceX - destX) / (sourceY - destY)));
		int X = (int) (spacer * dist * Math.cos(theta)) + ((sourceX + destX) / 2);
		int Y = (int) (spacer * dist * Math.sin(theta)) + ((sourceY + destY) / 2);
		return new Point(X,Y);
	}
}